# Instructions for AI Assistant - Markdown Zip and Sidebar Link

When creating or updating the wiki, generate a zip file of all content markdown files and link it in the Sidebar for download.

## Creating the Zip

From the repo root, create a zip named after the repo directory:

```bash
zip unnamed-2026-02-20.zip *.md
```

This includes all `.md` files in the root — wiki pages, transcript, chat, instructions, and Sidebar. It does not include `_bin/` scripts or other non-markdown files.

## Sidebar Link

The `Sidebar.md` file is generated by Markpub (a static site generator) and should contain a download link to the zip file. Add the following after the navigation section:

```markdown
Download [all pages](/unnamed-2026-02-20.zip)
for Obsidian or LLMs.
```

Note the two trailing spaces at the end of the zip link line — this is a Markdown line break. Without them, the two lines render as a single line. The line break is significant for readability on the published site.

The link uses an absolute path (`/`) so it resolves correctly from any page on the published site.

## When to Regenerate

Regenerate the zip whenever wiki content changes — new pages, renamed pages, updated content. The zip should always reflect the current state of the wiki.
